/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.util.exception;

import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.util.exception.FromModule;
import com.stratelia.webactiv.util.exception.WithNested;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.ejb.EJBException;

public abstract class SilverpeasException
extends Exception
implements WithNested,
FromModule {
    public static final int FATAL = 5;
    public static final int ERROR = 4;
    public static final int WARNING = 3;
    private int errorLevel = 4;
    private Exception nested = null;
    private String extraParams = "";
    private String callingClass = "NoClass";

    public SilverpeasException(String message) {
        this("noClass", 4, message, null, null);
    }

    public SilverpeasException(String message, Exception nested) {
        this("noClass", 4, message, null, nested);
    }

    public SilverpeasException(String message, Exception nested, int errorLevel) {
        this("noClass", errorLevel, message, null, nested);
    }

    public SilverpeasException(String callingClass, int errorLevel, String message) {
        this(callingClass, errorLevel, message, null, null);
    }

    public SilverpeasException(String callingClass, int errorLevel, String message, String extraParams) {
        this(callingClass, errorLevel, message, extraParams, null);
    }

    public SilverpeasException(String callingClass, int errorLevel, String message, Exception nested) {
        this(callingClass, errorLevel, message, null, nested);
    }

    public SilverpeasException(String callingClass, int errorLevel, String message, String extraParams, Exception nested) {
        super(message);
        this.callingClass = callingClass;
        this.errorLevel = errorLevel;
        this.extraParams = extraParams;
        this.nested = nested;
        if (errorLevel == 5) {
            SilverTrace.fatal((String)this.getModule(), (String)callingClass, (String)message, (String)extraParams, (Throwable)this);
        } else {
            SilverTrace.info((String)this.getModule(), (String)callingClass, (String)message, (String)extraParams, (Throwable)this);
        }
    }

    @Override
    public Exception getNested() {
        return this.nested;
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.out);
    }

    @Override
    public void printStackTrace(PrintStream s) {
        if (this.getNested() == null) {
            s.println(this.getMessageLang());
            super.printStackTrace(s);
        } else {
            Throwable e = null;
            s.println(this.getMessageLang());
            Collection<Throwable> exceptions = SilverpeasException.getChainedExceptions(this.getNested());
            Iterator<Throwable> i = exceptions.iterator();
            while (i.hasNext()) {
                e = i.next();
                if (!i.hasNext()) {
                    s.println("nested (Deepest) : ");
                    continue;
                }
                if (e instanceof FromModule) {
                    s.println("nested : " + ((FromModule)((Object)e)).getMessageLang());
                    continue;
                }
                s.println("nested : " + e.getMessage());
            }
            if (e != null) {
                e.printStackTrace(s);
            }
        }
    }

    @Override
    public void printStackTrace(PrintWriter w) {
        if (this.getNested() == null) {
            w.println(this.getMessageLang());
            super.printStackTrace(w);
        } else {
            Throwable e = null;
            w.println(this.getMessageLang());
            Collection<Throwable> exceptions = SilverpeasException.getChainedExceptions(this.getNested());
            Iterator<Throwable> i = exceptions.iterator();
            while (i.hasNext()) {
                e = i.next();
                if (!i.hasNext()) {
                    w.println("nested (Deepest) : ");
                    continue;
                }
                if (e instanceof FromModule) {
                    w.println("nested : " + ((FromModule)((Object)e)).getMessageLang());
                    continue;
                }
                w.println("nested : " + e.getMessage());
            }
            if (e != null) {
                e.printStackTrace(w);
            }
        }
    }

    @Override
    public abstract String getModule();

    @Override
    public String getMessageLang() {
        return SilverTrace.getTraceMessage((String)this.getMessage());
    }

    @Override
    public String getMessageLang(String language) {
        return SilverTrace.getTraceMessage((String)this.getMessage(), (String)language);
    }

    @Override
    public void traceException() {
        switch (this.errorLevel) {
            case 5: {
                SilverTrace.fatal((String)this.getModule(), (String)this.callingClass, (String)this.getMessage(), (String)this.extraParams, (Throwable)this);
                break;
            }
            case 4: {
                SilverTrace.error((String)this.getModule(), (String)this.callingClass, (String)this.getMessage(), (String)this.extraParams, (Throwable)this);
                break;
            }
            case 3: {
                SilverTrace.warn((String)this.getModule(), (String)this.callingClass, (String)this.getMessage(), (String)this.extraParams, (Throwable)this);
            }
        }
    }

    @Override
    public int getErrorLevel() {
        return this.errorLevel;
    }

    public String getExtraInfos() {
        return this.extraParams;
    }

    public static Collection<Throwable> getChainedExceptions(Throwable e) {
        ArrayList<Throwable> result = new ArrayList<Throwable>();
        Throwable throwable = e;
        while (throwable != null) {
            result.add(throwable);
            if (throwable instanceof WithNested) {
                throwable = ((WithNested)((Object)throwable)).getNested();
                continue;
            }
            if (throwable instanceof RemoteException) {
                throwable = ((RemoteException)throwable).detail;
                continue;
            }
            if (throwable instanceof EJBException) {
                throwable = ((EJBException)throwable).getCausedByException();
                continue;
            }
            throwable = null;
        }
        return result;
    }
}

